/*
 *  C++ Performance API wrapper tests.
 *
 *  Copyright 2012 Aurelian Melinte. 
 *  Released under GPL 3.0 or later. 
 */


#include <lpt/papi.hpp>


const int nlines = 196608;
const int ncols  = 64;
char ctrash[nlines][ncols];


//------------------------------------------------------------------------------
#define THRESHOLD 10000

void computation_mult()
{
   double tmp=1.0;
   int i=1;
   for( i = 1; i < THRESHOLD; i++ )
   {
      tmp = tmp*i;
   }
}

void computation_add()
{
   int tmp = 0;
   int i=0;

   for( i = 0; i < THRESHOLD; i++ )
   {
      tmp = tmp + i;
   }

}

//------------------------------------------------------------------------------


void tests()
{
   std::cout << "*\n"
                "* Baseline \n"
                "*\n";
   {
       lpt::papi::counters<lpt::papi::stdout_print> pc("Baseline add()");
       computation_add();
   }
   {
       lpt::papi::counters<lpt::papi::stdout_print> pc("Baseline mult()");
       computation_mult();
   }
       
   std::cout << "*\n"
                "* add & mult \n"
                "*\n";
   {
       lpt::papi::counters<lpt::papi::stdout_print> pc("add+mult no intermediate print");
       
       {
           lpt::papi::counters<lpt::papi::nop> pc2("add & no print");
           computation_add();
       }
       
       {
           lpt::papi::counters<lpt::papi::nop> pc2("mult & no print");
           computation_mult();
       }
   }
   {
       lpt::papi::counters<lpt::papi::stdout_print> pc("add+mult & print");
       
       {
           lpt::papi::counters<lpt::papi::stdout_print> pc2("add & print");
           computation_add();
       }
       
       {
           lpt::papi::counters<lpt::papi::stdout_print> pc2("mult & print");
           computation_mult();
       }
   }
    
   std::cout << "*\n"
                "* Atomics \n"
                "*\n";
   {
       int i = 0;
       lpt::papi::counters<lpt::papi::stdout_print> pc("Plain int");
       for (int i = 0; i < THRESHOLD; ++i) {
           i = i++;
       }
   }
   {
       std::atomic<int> i(0);
       lpt::papi::counters<lpt::papi::stdout_print> pc("Atomic int");
       for (int i = 0; i < THRESHOLD; ++i) {
           i++;
       }
   }
   
   std::cout << "*\n"
                "* Data cache trashing \n"
                "*\n";
   {
       int x;
       lpt::papi::counters<lpt::papi::stdout_print> pc("By line");
       for (int l = 0; l < nlines; ++l) {
           for (int c = 0; c < ncols; ++c) {
               x = ctrash[l][c];
           }
       }
   }
   {
       int x;
       lpt::papi::counters<lpt::papi::stdout_print> pc("by column");
       for (int c = 0; c < ncols; ++c) {
           for (int l = 0; l < nlines; ++l) {
               x = ctrash[l][c];
           }
       }
   }
   
   std::cout << "*\n"
                "* Data cache trashing - placate optimizer \n"
                "*\n";
   {
       int x;
       lpt::papi::counters<lpt::papi::stdout_print> pc("by column");
       for (int c = 0; c < ncols; ++c) {
           for (int l = 0; l < nlines; ++l) {
               x = ctrash[l][c];
               ctrash[l][c] = x + 1;
           }
       }
   }
   {
       int x;
       lpt::papi::counters<lpt::papi::stdout_print> pc("By line");
       for (int l = 0; l < nlines; ++l) {
           for (int c = 0; c < ncols; ++c) {
               x = ctrash[l][c];
               ctrash[l][c] = x + 1;
           }
       }
   }
}


int main()
{
    try
    {
        tests();
    }
    catch(lpt::papi::papi_error& ex)
    {
        std::cerr << "Exception " << ex.what() << std::endl;
        std::cerr << "At: \n"
                  << lpt::stack::call_stack_info< lpt::papi::papi_error::stack_type
                                                , lpt::stack::extended_symbol_info>(ex.where()) << std::endl;
    }
    catch(std::exception& ex)
    {
        std::cerr << ex.what() << std::endl;
    }

    exit(0);
}
